(ns codescene.features.api.spec.delta-analysis
  (:require [clojure.spec.alpha :as s]
            [spec-tools.spec :as spec])
  (:import (org.joda.time DateTime)))

(s/def ::page spec/int?)
(s/def ::max_pages spec/int?)
(s/def ::id spec/int?)
(s/def ::project_id spec/int?)
(s/def ::repository spec/string?)
(s/def ::ref spec/string?)
(s/def ::analysistime #(instance? DateTime %))
(s/def ::authors (s/coll-of spec/string?))
(s/def ::commits (s/coll-of spec/string?))
(s/def ::base_ref spec/string?)
(s/def ::delta_branch_head spec/string?)
(s/def ::external_review_id spec/string?)
(s/def ::loc spec/int?)
(s/def ::old-loc spec/int?)
(s/def ::code_health spec/float?)
(s/def ::old_code_health spec/float?)
(s/def ::added (s/coll-of spec/map?))
(s/def ::removed (s/coll-of spec/map?))
(s/def ::directives (s/keys :req-un [::added ::removed]))
(s/def ::enabled_gates spec/map?)
(s/def ::failed_gates spec/map?)
(s/def ::file spec/string?)
(s/def ::file_result (s/keys :req-un [::file] :opt-un [::loc ::old-loc ::code_health ::old_code_health]))
(s/def ::file_results (s/coll-of ::file_result))
(s/def ::delta_analyses (s/coll-of (s/keys :req-un [::id ::ref ::analysistime ::repository ::project_id])))
(s/def ::delta_analyses_list (s/keys :req-un [::page ::max_pages ::delta_analyses]))
(s/def ::delta_analysis (s/keys :req-un [::id ::project_id ::repository ::analysistime] 
                                :opt-un [::authors
                                         ::commits ::base_ref ::delta_branch_head
                                         ::external_review_id
                                         ::code_health ::old_code_health
                                         ::directives
                                         ::enabled_gates ::failed_gates
                                         ::file_results]))

