// @flow
import $ from 'jquery';
import * as pmIntegration from 'codescene-ui/src/configuration/pm-integration/pm-integration.jsx';

function setupPmDataProviderVisibility() {
  $('input[name="pm-data-provider-type"]').on('click',() => {
    var pmType = $('input[name="pm-data-provider-type"]:checked').val();
    var prType = $('input[name="pr-data-provider-type"]:checked').val();
    $('.jira-provider-toggleable').toggle(pmType == 'jira');
    $('.trello-provider-toggleable').toggle(pmType == 'trello');
    $('.azure-provider-toggleable').toggle(pmType == 'azure');
    $('.github-provider-toggleable').toggle(pmType == 'github');
    $('.gitlab-provider-toggleable').toggle(pmType == 'gitlab');
    $('.shortcut-provider-toggleable').toggle(pmType == 'shortcut');
    $('.youtrack-provider-toggleable').toggle(pmType == 'youtrack');
    $('.clickup-provider-toggleable').toggle(pmType == 'clickup');
    $('.pr-data-provider-toggleable').toggle(pmType != '');
    // Only show pr-data-provider credential options if selected and different from the pm-data-provider
    $('.azure-pr-data-provider-toggleable').toggle(pmType != 'azure' && prType == 'azure');
    $('.github-pr-data-provider-toggleable').toggle(pmType != 'github' && prType == 'github');
    $('.gitlab-pr-data-provider-toggleable').toggle(pmType != 'gitlab' && prType == 'gitlab');
  });
  $('input[name="pr-data-provider-type"]').on('click',() => {
    var pmType = $('input[name="pm-data-provider-type"]:checked').val();
    var prType = $('input[name="pr-data-provider-type"]:checked').val();
    $('.azure-pr-data-provider-toggleable').toggle(pmType != 'azure' && prType == 'azure');
    $('.bitbucket-pr-data-provider-toggleable').toggle(prType == 'bitbucket');
    $('.bitbucket-server-pr-data-provider-toggleable').toggle(prType == 'bitbucket-server');
    $('.github-pr-data-provider-toggleable').toggle(pmType != 'github' && prType == 'github');
    $('.gitlab-pr-data-provider-toggleable').toggle(pmType != 'gitlab' && prType == 'gitlab');
  });
}

export function init() {
  setupPmDataProviderVisibility();
}

export function initDetails (mountPoint: any, data: any, options: any) {
  pmIntegration.init(mountPoint, data, options);
}

