// @flow
import $ from 'jquery';
import 'tablesorter';

import * as tableSorter from 'codescene-ui/src/table-sorter';

/**
 * Deletes the given team. Returns a promise of wheather or not the team was
 * deleted, as the user might abort.
 */
function deleteTeam(settingsId, teamId, teamName) : Promise<boolean> {
  if (!confirm('Are you sure you want to permanently delete the Team ' + teamName + '?')) {
    return Promise.resolve(false);
  }

  return new Promise((resolve, reject) => {
    $.ajax({
      type: 'POST',
      url: `${window.baseUrl}developer-configurations/${settingsId}/teams/delete`,
      data: { teamid: teamId },
      success: function () {
        resolve(true);
      },
      error: function (xhr) {
        reject(xhr.responseText);
      }
    });
  });
}

export function init(settingsId : number) {
  const table = $('#all-teams-table');

  table.find('.delete-team-button')
    .on('click', function () {
      const teamId = $(this).data('team-id');
      const teamName = $(this).data('team-name');
      deleteTeam(settingsId, teamId, teamName)
        .then(deleted => {
          if (deleted) {
            $('tr[data-team-id=' + teamId + ']').remove();
          }
        })
        .catch((err) => {
          alert('Failed to delete the Team ' + teamName + '. Reason: ' + err);
        });
      return false;
    });

  $.tablesorter.addParser({
    id: 'input-sorter',
    is: () => false,
    format: (s, table, cell) => {
      return $('input', cell).val();
    },
    type: 'text'
  });

  tableSorter.sort(table, {
    headers: {
      '0': {
        sorter: 'input-sorter'
      },
      '1': {
        sorter: 'input-sorter'
      },
      '2': {
        sorter: false
      }
    }
  });
}
