// @flow
import $ from 'jquery';
import d3 from 'd3';

import * as tabulator from 'codescene-ui/src/tabulator';
import * as tableSorter from 'codescene-ui/src/table-sorter';

function wrapFileName(d) {
  return '<span class="filename">' + d + '</span>';
}

function columnHeading(column) {
  switch (column) {
  case 'entities':
    return 'Logically Related Parts';
  case 'totalproximity':
    return 'Total Proximity';
  }
}

export function renderPairwiseRestructureRecommendationsTable(data : any, $container : $) {
  var table = d3.select($container.get(0)).append('table')
    .attr('id', 'proximity-table')
    .classed('table table-striped table-hover', true);
  var thead = table.append('thead');
  var tbody = table.append('tbody');

  // append the header row
  thead.append('tr')
    .selectAll('th')
    .data(['entities', 'totalproximity'])
    .enter()
    .append('th')
    .attr('class', function(column) { return 'column-' + tabulator.safeClassName(column);})
    .text(columnHeading);

  // create a row for each object in the data
  var rows = tbody.selectAll('tr')
    .data(data)
    .enter()
    .append('tr');

  // create a cell in each row for each column
  rows.selectAll('td')
    .data(function(row) {
      var entities = {
        column: 'entities',
        html: '<div class=\'modules\'>' + wrapFileName(row.entity1) + wrapFileName(row.entity2) + '</div>'
      };
      var otherCells = ['totalproximity'].map(function(column) {
        return {
          column: column,
          html: row[column]
        };
      });

      return [entities].concat(otherCells);
    })
    .enter()
    .append('td')
    .attr('class', function(d) { return 'column-' + tabulator.safeClassName(d.column);})
    .html(function(d) { return d.html; });

  tableSorter.sort($(table[0]), {});

  return table;
}
