// @flow
import $ from 'jquery';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as alerts from 'codescene-ui/src/alerts';
import KnowledgeMap from 'codescene-ui/src/analyses/knowledge-map';

type View =
  "Authors"
    | "Teams";

/*
 TODO: enable this when a generated color palette should be used

function viewErrorHtml(view, projectId) {
  return {
    Authors:
      `<strong>There are no active developers in your project.</strong>
      Are all developers marked as ex-developers in <a class="alert-link" href="{{view-context}}/projects/${projectId}/developers">the configuration</a>?`,
    Teams:
      `<strong>You have no teams configured.</strong> Add teams in the <a
      class="alert-link"
      href="{{view-context}}/projects/${projectId}/teams">project
      configuration</a>, and then <a
      class="alert-link"
      href="{{view-context}}/projects/${projectId}/developers">assign
      developers</a> to those teams. Run a new analysis and you will have
      access to this analysis result.`
  }[view];
}
*/

type ViewOptions = {
  view : View,
  knowledgeDistributionUrl : string,
  useOpacity : boolean,
  minimumLabelSize : number,
  projectId: number
};

export function init(options : ViewOptions) {
  var container =  $('#knowledgemap');
  if (container.length == 0) {
    return;
  }

  var showLabelsToggle =  $('#show-labels-toggle');
  var map = new KnowledgeMap(container, options.minimumLabelSize);
  // TODO: change to this when a generated color palette should be used
  //const topAuthorsLimit = 20;
  //const map = new KnowledgeMap(container, options.minimumLabelSize, topAuthorsLimit, viewErrorHtml(options.view, options.projectId));

  xhr.json(options.knowledgeDistributionUrl)
    .then(knowledgeDistribution => {
      map.draw(knowledgeDistribution);
    })
    .catch(err => {
      console.error(err.stack);
      alerts.error(container, 'Failed to load knowledge distribution data.');
    });

  showLabelsToggle.on('change', () => {
    map.toggleLabels(showLabelsToggle.is(':checked'));
  });
}
