-- name: select-all-providers
-- Returns basic data for all notification providers.
-- More details can be fetched with `select-provider-config` and `select-provider-notifications`.
select p.id as provider_id, p.type as provider_type, p.active as active, p.recipient as recipient
from notification_providers p;

-- Note that there's no `select-provider-project-config` because this config settings are only global
-- (we only override 'recipient' and 'notifications')
-- name: select-provider-config
-- Selects configuration properties for given provider
select pc.`key`, pc.`value`
from notification_providers_config pc
  join notification_providers p on pc.provider_id = p.id
where p.id = :provider_id;

-- name: select-provider-notifications
select notification_id, active as active
from provider_notifications
where provider_id = :provider_id;

-- name: save-provider<!
-- Inserts new provider
INSERT INTO notification_providers (type, active, recipient)
VALUES (:type, :active, :recipient);

-- name: update-provider!
-- Update an existing provider
-- Notice that we don't update `priority_order` field since we don't have it available on UI
UPDATE notification_providers
SET active = :active, recipient = :recipient
WHERE type = :type;

-- Notice that `key` is escaped to avoid reserved-word issues with MySQL et al

-- name: insert-provider-config-property!
-- Inserts or updates a single key-value pair representing specifig config property for given provider
INSERT INTO notification_providers_config (provider_id, `key`, `value`)
VALUES (:provider_id, :provider_key, :provider_value);

-- name: update-provider-config-property!
-- Updates a single key-value pair representing specifig config property for given provider
UPDATE notification_providers_config
SET `value` = :provider_value
WHERE provider_id = :provider_id AND `key` = :provider_key;

-- name: insert-provider-notifications!
-- Insert provider specific notification settings.
INSERT INTO provider_notifications (provider_id, notification_id, active)
VALUES (:provider_id, :notification_id, :active);

-- name: update-provider-notifications!
-- Update provider specific notification settings.
UPDATE provider_notifications
SET active = :active
WHERE provider_id = :provider_id AND notification_id = :notification_id;


----------------------------------------------
-- project-specific notification configuration
----------------------------------------------

-- name: select-project-provider
-- Returns basic data for all notification providers.
-- More details can be fetched with `select-provider-config` and `select-provider-notifications`.
select p.id as project_provider_id,
       p.provider_id as provider_id,
       p.override as override,
       p.recipient as recipient
  from project_notification_providers p
 where provider_id = :global_provider_id
       and project_id = :project_id;

-- name: select-project-provider-notifications
-- Project-specific notifications for given provider
select notification_id, active
  from project_provider_notifications pn
 where project_provider_id = :project_provider_id;

-- name: insert-project-provider<!
-- Inserts new provider
INSERT INTO project_notification_providers (provider_id, project_id, override, recipient)
VALUES (:global_provider_id, :project_id, :override, :recipient);

-- name: update-project-provider!
-- Update an existing provider
UPDATE project_notification_providers
   SET override = :override,
       recipient = :recipient
 WHERE provider_id = :global_provider_id AND project_id = :project_id

-- name: insert-project-provider-notifications!
-- Insert provider specific notification settings.
INSERT INTO project_provider_notifications (project_provider_id, notification_id, active)
VALUES (:project_provider_id, :notification_id, :active);

-- name: update-project-provider-notifications!
-- Update provider specific notification settings.
UPDATE project_provider_notifications
   SET active = :active
 WHERE project_provider_id = :project_provider_id AND notification_id = :notification_id;

