-- name: select-note-by-id
select id, project_id, note_text, repo_path, original_entity, original_rev, last_entity, last_rev, category, created, modified
       from project_notes
       where id = :id

-- name: select-notes-by-project
select id, project_id, note_text, repo_path, original_entity, original_rev, last_entity, last_rev, category, created, modified
       from project_notes
       where project_id = :project_id

-- name: select-note-by-filename
select id, project_id, note_text, repo_path, original_entity, original_rev, last_entity, last_rev, category, created, modified
       from project_notes
       where project_id = :project_id
       and last_entity = :entity

-- name: insert-note<!
insert into project_notes
       (project_id, repo_path, original_entity, original_rev, last_entity, last_rev, note_text, category)
       values
       (:project_id, :repo_path, :original_entity, :original_rev, :original_entity, :original_rev, :note_text, :category)

-- name: update-note-by-id!
-- Update user fields in an existing note
update project_notes
       set note_text =:note_text, category = :category, modified = current_timestamp()
       where id = :id and project_id = :project_id

-- name: update-note-entity-by-id!
-- Set the last-entity and last-rev fields on an existing note
update project_notes
       set last_entity = :last_entity, last_rev = :last_rev
       where id = :id and project_id = :project_id

-- name: update-note-repo-path-by-id!
-- Updates the repo path in case the Git repositories where moved on disk due to configuration changes.
update project_notes
       set repo_path = :repo_path
       where id = :id and project_id = :project_id

-- name: reset-supervised-note-to-current-rev!
-- Updates *-rev and *-entity fields. Use case is "resetting" an improved note to its new baseline       
update project_notes
       set original_entity = :entity, original_rev = :rev, last_entity = :entity, last_rev = :rev
       where id = :id
             and project_id = :project_id

-- name: delete-note-by-project-and-id!
delete from project_notes
       where project_id = :project_id
       and id = :id
