public class BumpyRoadExample {
	public void processDirectory(String path) {
		// Find all files matching "data<number>.csv".
		List<String> files = new ArrayList<String>();
		File dir = new File(path);
		for (File file : dir.listFiles()) {
			if (file.isFile() && file.getName().matches("data\\d+\\.csv")) {
				files.add(file.getAbsolutePath());
			}
		}

		// Concatenate all the files into one
		StringBuilder sb = new StringBuilder();
		for (File file : files) {
			try (BufferedReader br = new BufferedReader(new FileReader(file))) {
				String line = br.readLine();
				while (line != null) {
					sb.append(line);
					line = br.readLine();
				}
			}
		}

		// Write the concatenated file to disk
		try (BufferedWriter bw = new BufferedWriter(new FileWriter("data.csv"))) {
			bw.write(sb.toString());
		}
	}
}
