(ns kmeans-clj.util)

(defn argmin
  "Returns the item in coll which results in the minimal value for f."
  [f coll]
  (loop [[item & more] coll
         min-val Long/MAX_VALUE
         min-items []]
    (if item
      (let [item-val (f item)]
        (if (= item-val min-val)
          (recur more item-val (conj min-items item))
          (if (< item-val min-val)
            (recur more item-val [item])
            (recur more min-val min-items))))
      (when-not (empty? min-items) (rand-nth min-items)))))
