grammar ScalaMethodArguments;
options {superClass=hotspots_x_ray.languages.InterruptibleParser;}

import ScalaSharedRulesParser;

singlefunctionscope
:
	expression* EOF
;

expression : function_declaration
           | anything;

anything: .;

// NOTE: Scala supports multiple parameter lists
function_declaration : DEF function_name generic_signature? function_args* function_return_signature? anything*;

function_args : LeftParen function_definition_params_list_details? RightParen;

fun_arg : argument_modifier? parameter;
parameter: arg_name COLON arg_type_spec;
arg_name: id_name;

argument_modifier: 'implicit';

// Here's a slight problem: I have know idea what the proper terminology actually is in Scala :/

arg_type_spec : ARROW type_name // => Unit
              | type_name (ARROW type_name) // Symbol => Boolean
              | plain_type_arg // Int
              | type_name generic_arg_signature // PartialFunction[Tree, Tree]
              | multi_arity_arg; // (Symbol, Symbol)*

plain_type_arg: type_name;

arg_type_list: arg_type_spec
             | arg_type_list ',' arg_type_spec;

generic_arg_signature: LeftSquare arg_type_list? RightSquare;
multi_arity_arg: LeftParen arg_type_list RightParen STAR*?;

nested_type_name: id_name
                | id_name '.' nested_type_name;

type_name: id_name | multi_arity_arg | nested_type_name;

function_definition_params_list_details : fun_arg
                                        | function_definition_params_list_details ',' fun_arg;
