lexer grammar JavaSharedRulesLexer;

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

fragment MULTI_LINE_STRING_DELIMITER: '"""';
MULTI_LINE_STRING: MULTI_LINE_STRING_DELIMITER .*? MULTI_LINE_STRING_DELIMITER;

LITERAL_CHAR : '\'' . '\'' -> skip;

DOT_CLASS: '.class'; // for dynamic introspection, lex it separately since the anything parse rule matches on ~CLASS
CLASS : 'class';
INTERFACE : 'interface';
ENUM : 'enum';
RECORD: 'record';
THROWS : 'throws';

PRIVATE: 'private';
PROTECTED: 'protected';
PUBLIC: 'public';

FINAL: 'final';
STATIC: 'static';
ABSTRACT: 'abstract';
TRANSIENT: 'transient';
SYNCHRONIZED: 'synchronized';
VOLATILE: 'volatile';

LeftParen : '(';
RightParen: ')';

LeftBrace : '{';
RightBrace : '}';

SEMICOLON : ';';

AT_SIGN: '@';

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

ID : [a-zA-Z_][a-zA-Z0-9_]*;

SCOPER : '.';
SCOPED_NAME : SCOPER? ID (SCOPER ID)+;

INT : [0-9]+;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence