lexer grammar CSharpSharedRulesLexer;

// Pre-processor directives: since we already handle top-level blocks we're free to
// ignore multi-line macros, etc. All that we need es to identify conditional compilation
// directives _inside_ functions. We need to parse them away because they may lead to
// unbalanced curly braces otherwise.

SHARP : '#';

PRE_PROC_IF : SHARP 'if';
PRE_PROC_IFDEF : SHARP 'ifdef';
PRE_PROC_IFNDEF : SHARP 'ifndef';

PRE_PROC_ELSE : SHARP 'else';

PRE_PROC_ENDIF: SHARP 'endif';

PRE_PROC_DEFINE : SHARP 'define' (~[\\\r\n]*? [\\] '\r'? '\n')+? (~[\\]*? '\r'? '\n') -> skip;

PRE_PROC_SKIP_DEFINE : SHARP 'define' ~('\r' | '\n' | '\\')+?  '\r'? '\n' -> skip;
INCLUDE : SHARP 'include' ~('\r' | '\n')+? '\r'? '\n' -> skip;
PRAGMA : SHARP 'pragma' ~('\r' | '\n')+? '\r'? '\n' -> skip;
UNDEF : SHARP 'undef'  ~('\r' | '\n')+? '\r'? '\n' -> skip;

START_REGION : SHARP 'region' ~('\r' | '\n')*? '\r'? '\n' -> skip;
END_REGION: SHARP 'endregion' '\r'? '\n' -> skip;

fragment VERBATIM_ESCAPE : '""';
VERBATIM_STRING : '@' '"' ( VERBATIM_ESCAPE | ~('"'))* '"';

fragment ESCAPED : '\\\\' | '\\"';
LITERAL : '"' ( ESCAPED | ~('\n'|'\r') )*? '"';

LITERAL_CHAR : '\'' . '\'' -> skip;

ARROW_OPERATOR: '=>';

CLASS : 'class';
STRUCT : 'struct';
RECORD : 'record';
NAMESPACE : 'namespace';

PUBLIC: 'public';
PROTECTED: 'protected';
PRIVATE: 'private';
ABSTRACT: 'abstract';
INTERNAL: 'internal';

LeftParen : '(';
RightParen: ')';

LeftBrace : '{';
RightBrace : '}';

SEMICOLON : ';';

Whitespace : [ \t]+ -> skip;

BlockComment: '/*' .*? '*/' -> skip;
LineComment: '//' ~[\r\n]* -> skip;

NEWLINE : '\r'? '\n' -> skip;

ID : [a-zA-Z_][a-zA-Z0-9_]*;

SCOPER : '.';
SCOPED_NAME : SCOPER? ID (SCOPER ID)+;

INT : [0-9]+;

ANY_CHAR : .; // Put this lexer rule last to give it the lowest precedence
