(ns codescene.features.util.csv
  (:require [clojure.java.io :as io]
            [semantic-csv.core :as scsv]))

(defn read-csv
  ([dir filename mappify]
  (let [file (io/file dir filename)]
    (if (.exists file)
      (scsv/slurp-csv file {:mappify mappify})
      [])))
  ([dir filename]
   (read-csv dir filename true))
  ([source]
   (let [file (io/file source)]
     (read-csv (.getParent file) (.getName file) true))))
