(ns codescene.features.time-series.project-status
  (:require
   [clojure.java.io :as io]
   [codescene.analysis.paths :as paths]
   [codescene.features.time-series.core :as tsc]
   [codescene.features.time-series.time-series-db :as time-series-db]
   [codescene.util.json :as json]
   [codescene.util.csv-conversions :as csv]
   [codescene.features.util.number :as num]
   [medley.core :as m]))



(defn- extract-analysis-statistics
  [stats]
  (-> stats
      (select-keys [:active-authors :athors :files :files-scoreable :files-with-code-health])
      (m/update-existing :application-code-loc (fnil num/as-int 0))
      (m/update-existing :architecturaldefs (fnil num/as-int 0))
      (m/update-existing :teams (fnil num/as-int 0))))

(defn- format-analysis-error-log
  [error-log]
  (if error-log 
    (map #(select-keys % [:category :description :remedy]) error-log)
    []))

(defn- extract-repos
  [author-churn-per-repo]
  (->> author-churn-per-repo keys (mapv name)))

;;; Second extract/formatting fn is optional.
(def json-files-to-get
  {:config-diagnostics [paths/four-factors-configuration-diagnosis-json]
   :analysis-statistics [paths/analysis-statistics-json extract-analysis-statistics]
   :run-summary [paths/run-summary-json]
   :analysis-error-log [paths/analysis-error-log-json format-analysis-error-log]
   :repos [paths/author-churn-per-repo-json extract-repos]})

(defn- dashboard-fields
  [dash]
  (select-keys dash [:application-code-loc :architecturaldefs :teams]))

;;; Third extract/formatting fn is optional.
;;; Since there are different ways to read a csv file, we require a second fn here.
(def csv-files-to-get
  {:dashboard [paths/dashboard-csv csv/csv->map dashboard-fields]})

(defn- extract-json
  [analysis-results-path]
  (let [{:keys [dashboard] :as data}
        (into {}
              (concat
               (map (fn [[k [path extract]]]
                      [k
                       (let [extract-fn (or extract identity)]
                         (extract-fn (json/read-when-exists (io/file analysis-results-path path))))])
                    json-files-to-get)
               (map (fn [[k [path read-fn extract]]]
                      [k
                       (let [extract-fn (or extract identity)]
                         (extract-fn (read-fn (io/file analysis-results-path path))))])
                    csv-files-to-get)))]
    (-> data
        (update :analysis-statistics merge dashboard)
        (dissoc :dashboard))))


(defn append-analysis-result-file
  [db-spec project-id timestamp analysis-results-path]
  (time-series-db/insert-entry
   db-spec
   "project-status"
   {:project-id project-id
    :timestamp timestamp
    :payload (assoc (extract-json analysis-results-path) :timestamp (tsc/to-json-date timestamp))}))


(comment
  (extract-json "/Users/joseph/Empear/testing/local-codescene-worker-results/982/62ee103c-cdf3-4c65-ad3c-f80ee044fd43/results/analysis20250408122440"))
