(ns codescene.features.spec.auth
  (:require [clojure.spec.alpha :as s])
  (:import (org.joda.time DateTime)))

(s/def ::principals coll?)
(s/def ::groups coll?)
(s/def ::identity string?)
(s/def ::admin? boolean?)

(s/def ::account-id int?)
(s/def ::user-id int?)
(s/def ::expiry-date #(instance? DateTime %))
(s/def ::privileges (s/coll-of string?))

(s/def ::user (s/or
                :onprem-user (s/keys :req-un [::identity ::admin? ::privileges])
                :cloud-account (s/keys :req-un [::user-id ::account-id ::expiry-date ::privileges])))
