(ns codescene.features.reports.report-dispatcher
  (:require [codescene.features.reports.four-factor-reports :as reports]
            [codescene.features.reports.legacy-reports :as legacy-reports]))

(defn dispatch
  "Dispatches report based on report type, using the relevant parameters."
  ([report-type system project-id]
   (dispatch report-type system project-id nil nil nil))
  ([report-type system projects account-info]
   (dispatch report-type system nil projects account-info nil))
  ([report-type system project-id projects account-info feature-flags]
   (case report-type
     :software-portfolio-overview
     (reports/generate-portfolio-report system projects account-info)
     :code-health-overview
     (reports/generate-code-health-report system project-id)
     :management
     (legacy-reports/generate-management-report system {} projects)
     (:technical-health-overview :trend-report :key-personnel-and-knowledge-distribution)
     (legacy-reports/generate-project-report system feature-flags project-id report-type)
     (legacy-reports/generate-custom-report system projects report-type))))
