(ns codescene.features.reports.code-health.trend-graph
  (:require
   [codescene.features.reports.pdf-helpers :as ph]
   [codescene.features.reports.graphics.functions :as graphics]
   [codescene.features.reports.common.pdf-elements :as pdf-elements]
   [codescene.features.reports.common.styling :as styling]
   [codescene.features.presentation.factor-metadata :as metadata]
   [medley.core :as m]))

(defn- legend-row [img-dir]
  (let [red-dot (styling/load-resource img-dir "red-dot.png")
        orange-dot (styling/load-resource img-dir "orange-dot.png")
        green-dot (styling/load-resource img-dir "green-dot.png")]
    (ph/row
      (ph/table
        [] [3 1 18 3 1 20 3 1 18 130]
        (ph/row
          (ph/cell [:c-dot-cell] (ph/image [:c-image-dot] green-dot))
          ""
          (ph/cell [:c-dot-legend-cell] (ph/paragraph [:c-dot-legend-paragraph] "Healthy"))
          (ph/cell [:c-dot-cell] (ph/image [:c-image-dot] orange-dot))
          ""
          (ph/cell [:c-dot-legend-cell] (ph/paragraph [:c-dot-legend-paragraph] "Problematic"))
          (ph/cell [:c-dot-cell] (ph/image [:c-image-dot] red-dot))
          ""
          (ph/cell [:c-dot-legend-cell] (ph/paragraph [:c-dot-legend-paragraph] "Unhealthy"))
          (ph/cell [] ""))))))

(defn pdf-element [{:keys [code-health]} {:keys [img-dir dashboard-url]} beginning end]
  (let [empty-icon (styling/load-resource img-dir "Empty.png")
        score-levels (:score-levels (metadata/metadata-for :average-code-health))
        score-bounds (:interval (m/find-first #(= "Problematic" (:label %)) (:ranges score-levels)))]
    (ph/table
      [:c-card-content-top-table] nil
      (ph/row
        (ph/table
          [] nil
          (ph/row
            (ph/cell [] (ph/paragraph [:c-miniheader] "AVERAGE CODE HEALTH TREND") [:spacer 1])
            (ph/cell [:act-link-cell] (ph/table [] [10 1] (pdf-elements/link-row dashboard-url "Go to Dashboard" img-dir))))))
      (legend-row img-dir)
      (ph/row
        (ph/cell
          [:act-graphics-surrounding-cell]
          (if (seq code-health)
            (ph/table
              [:act-graphics-table] [300]
              (ph/row
                (ph/cell
                  [:act-graphics-cell]
                  {:background-layer-fn
                   (ph/draw-using-g2d-fn
                     (graphics/code-health-chart-fn code-health score-bounds beginning end))})))
            (ph/table
              [:act-empty-graphics-table] [300]
              (ph/row (ph/cell [:act-empty-graphics-cell1] (ph/image [:act-empty-image] empty-icon)))
              (ph/row (ph/cell [:act-empty-graphics-cell2] (ph/paragraph [:c-dot-legend-paragraph] "Currently, there is no trend to show"))))))))))

