(ns codescene.features.presentation.scoring
  (:require [codescene.factors.code-health.presentation :as chp]
            [codescene.factors.knowledge.presentation :as kp]
            [codescene.factors.presentation.scoring :as scoring]
            [codescene.factors.team-code.presentation :as tcp]
            [codescene.factors.delivery.presentation :as dp]))

(def ^:private score-fns {chp/kpi-key chp/score-aggregated-kpi
                          chp/hotspots-code-health-key chp/score-sub-kpi
                          chp/average-code-health-key chp/score-sub-kpi
                          chp/worst-performer-key chp/score-sub-kpi
                          kp/kpi-key kp/score-aggregated-kpi
                          kp/knowledge-islands-key kp/score-knowledge-islands
                          kp/code-familiarity-key kp/score-code-familiarity
                          tcp/kpi-key tcp/score-aggregated-kpi
                          tcp/team-cohesion-key tcp/score-team-cohesion
                          tcp/team-coupling-key tcp/score-team-coupling
                          dp/kpi-key dp/score-aggregated-kpi
                          dp/development-time-key dp/score-development-time
                          dp/unplanned-work-key dp/score-unplanned-work})

(defn- score-info-for*
  [value factor-key]
  (if-let [score-fn (get score-fns factor-key)]
    (score-fn value)
    scoring/not-applicable))

(defn score-info-for
  "Calculates scoring info for a given value and factor key and
  returns a map with keys :level and :label, where the level indicates if
  the result is semantically 'bad' or 'good' ranging from 0-2. nil values
  or factors not implemented will return -1, meaning N/A.
  The label is a string describing the score.

  Note that the input value unit might differ between factors. For
  example knowledge distribution is scored in percent 0-100, while
  development time is scored in minutes.
  See codescene.factors.*.presentation for details."
  [value factor-key]
  #?(:clj  (score-info-for* value factor-key)
     :cljs (clj->js (score-info-for* value (keyword factor-key)))))
