(ns codescene.features.pm-data.shortcut.shortcut-fetcher
  (:require [taoensso.timbre :as log]
            [codescene.features.pm-data.shortcut.shortcut-api :as api]))

(defn- issue->response
  [issue]
  (let [{:keys [id story_type estimate app_url
                created_at completed_at started_at completed_at_override updated_at]} issue
        completed_at (or completed_at_override completed_at)]
    {:id         (str "sc-" id)
     :href        app_url
     :created     created_at
     :closed      nil
     :updated     updated_at
     :status      nil
     :cost        (or estimate 0)
     :work-types  [story_type]
     :transitions (filterv some?
                          [(when started_at ["started" started_at])
                           (when completed_at ["completed" completed_at])])}))


(defn- project->response
  [{:keys [name id] :as _project}]
  {:key id
   :name name})

(defn fetch-projects
  [api-token]
  (log/infof "Fetch projects from Shortcut")
  (->> (api/fetch-projects api-token)
       (map project->response)
       (into [])))

(defn fetch-issues
  [since api-token project]
  (let [search-options {:project project
                        :since since}]
    (log/infof "Fetch issues from Shortcut since %s" (or since "-"))
    (->> (api/search-stories api-token search-options)
         (map issue->response)
         (into []))))

(def fetch-member api/fetch-member)

(comment
  (def api-client (codescene.features.pm-data.shortcut.shortcut-api/shortcut-auth (System/getenv "SHORTCUT_TOKEN")))
  (def project "API")
  (def since (evolutionary-metrics.trends.dates/string->date "2022-02-10"))
  (fetch-projects api-client)
  (fetch-issues since api-client project))
