(ns codescene.features.pm-data.jira.jira-cache
  "Wraps some fetcher fns to make them cacheable"
  (:require [codescene.features.pm-data.jira.jira-fetcher :as f]
            [codescene.features.pm-data.cache :as cache]))

(defn- fetch-issues-key-fn
  [_ _ project {:keys [supported-work-types use-labels-as-work-types cost-field  cost-unit] :as _provider-def}]
  [project supported-work-types use-labels-as-work-types cost-field  cost-unit])

(def ^:private fetch-issues-cacheable (cache/make-cacheable f/fetch-issues))
(cache/memo #'fetch-issues-cacheable fetch-issues-key-fn)

(defn fetch-issues
  [since api-client project provider-def]
  (cache/combine-with-cache fetch-issues-cacheable fetch-issues-key-fn
                            since api-client project provider-def))

(defn- fetch-links-key-fn
  [_ _ project]
  [project])

(def ^:private fetch-links-cacheable (cache/make-cacheable f/fetch-links))
(cache/memo #'fetch-links-cacheable fetch-links-key-fn)

(defn fetch-links
  [since api-client project]
  (cache/combine-with-cache fetch-links-cacheable fetch-links-key-fn
                            since api-client project))

(comment

  (def api-client (codescene.features.client.api/->ExtraProperties
                   {:api-url "https://issues.apache.org/jira/rest/api/2"}
                   nil))
  (def project "ZOOKEEPER")
  (def provider-def {:work-in-progress-transition-names ["In Progress"]
                     :use-labels-as-work-types nil
                     :defect-and-failure-labels ["Bug"]
                     :rename-work-types []
                     :work-done-transition-names ["Closed" "Resolved" "Done"]
                     :map-commits-to-pull-request-issues nil
                     :project-aliases []
                     :supported-work-types ["pull-request-available"]
                     :work-done-transition-name "Closed"
                     :map-subtasks-to-parent-issues true
                     :external-project-ids ["ZOOKEEPER"]
                     :uses-supported-work-types false
                     :cost-field "aggregatetimeoriginalestimate"
                     :cost-unit "issues"})

  (let [since (evolutionary-metrics.trends.dates/string->date "2021-07-01")]
    (codescene.cache.core/with-file-cache "." "." :pm-data
      {:issues (count (fetch-issues since api-client project provider-def))
       :links (count (fetch-links since api-client project))}))
  )

