(ns codescene.features.pm-data.gitlab.pr-data-provider
  (:require [codescene.features.pm-data.pr-data-provider :refer [-create PrDataProvider]]
            [codescene.features.pm-data.gitlab.cache :as cache]
            [codescene.features.pm-data.gitlab.fetcher :as fetcher]
            [codescene.url.url-utils :as url]
            [evolutionary-metrics.trends.dates :as dates]))

(defn fetch-merge-requests
  [api-client repo-url since]
  (if-let [repo-info (url/repo-url->repo-info* repo-url :gitlab false)]
    (cache/fetch-merge-requests since api-client repo-info)
    []))

(defn- validate-settings
  "Validate settings by trying to fetch the latest PR data"
  [{:keys [api-client] :as _provider-def} {:keys [repo-urls] :as _pr-data-context}]
  (when-let [repo-info (-> repo-urls first (url/repo-url->repo-info :gitlab false))]
    (fetcher/fetch-merge-requests (dates/start-of-day) api-client repo-info)))

(defn- get-pull-requests
  [{:keys [api-client] :as _provider-def} {:keys [repo-urls] :as _pr-data-context} since]
  (->> repo-urls
       (mapcat #(fetch-merge-requests api-client % since))
       (into [])))

(deftype GitLabProvider [provider-def pr-data-context]
  PrDataProvider
  (-validate-settings [_this](validate-settings provider-def pr-data-context))
  (-get-pull-requests [_this since] (get-pull-requests provider-def pr-data-context since)))

(defmethod -create "gitlab"
  [provider-def pr-data-context]
  (->GitLabProvider provider-def pr-data-context))

(comment
  (def api-client {:api-client (System/getenv "GITLAB_TOKEN")})
  (def context {:repo-urls ["git@gitlab.com:empear/analysis-target.git"]})
  (validate-settings api-client context)
  (get-pull-requests api-client context nil)
  )
