(ns codescene.features.pm-data.github.github-cache
  "Wraps some fetcher fns to make them cacheable"
  (:require [codescene.features.pm-data.github.github-fetcher :as ghf]
            [codescene.features.pm-data.cache :as cache]))

(defn- fetch-issues-key-fn
  [_ _ owner repo {:keys [supported-work-types] :as _provider-def}]
  [owner repo supported-work-types])

(def ^:private fetch-issues-cacheable (cache/make-cacheable ghf/fetch-issues))
(cache/memo #'fetch-issues-cacheable fetch-issues-key-fn)

(defn fetch-issues
  [since api-client owner repo provider-def]
  (cache/combine-with-cache fetch-issues-cacheable fetch-issues-key-fn 
                            since api-client owner repo provider-def))

(defn- fetch-pull-requests-key-fn
  [_ _ owner repo]
  [owner repo])

(def ^:private fetch-pull-requests-cacheable (cache/make-cacheable ghf/fetch-pull-requests))
(cache/memo #'fetch-pull-requests-cacheable fetch-pull-requests-key-fn)

(defn fetch-pull-requests
  [since api-token owner repo]
  (cache/combine-with-cache fetch-pull-requests-cacheable fetch-pull-requests-key-fn 
                            since api-token owner repo))

(def ^:private fetch-pull-requests-numbers-cacheable (cache/make-cacheable ghf/fetch-pull-request-numbers))
(cache/memo #'fetch-pull-requests-numbers-cacheable fetch-pull-requests-key-fn)

(defn fetch-pull-request-numbers
  [since api-client owner repo]
  (cache/combine-with-cache fetch-pull-requests-numbers-cacheable fetch-pull-requests-key-fn 
                            since api-client owner repo))

(comment
  (def api-token (System/getenv "GITHUB_TOKEN"))
  (def owner "dotnet")
  (def repo "aspnetcore")
  (let [since (evolutionary-metrics.trends.dates/string->date "2022-07-10")]
    (codescene.cache.core/with-file-cache "." "." :pm-data
      {:issues (count (fetch-issues since api-token owner repo {}))
       :fetch-pull-requests (count (fetch-pull-requests since api-token owner repo))
       :fetch-pull-request-numbers (count (fetch-pull-request-numbers since api-token owner repo))})))
