(ns codescene.features.module
  (:require [duct.core :as duct]
            [duct.core.merge :refer [displace]]
            [integrant.core :as ig]
            [medley.core :refer [assoc-some]]))

(defmethod ig/init-key ::reports [_ _]
     #(duct/merge-configs
        %
        {:codescene.features.reports/report-component
         {:project-component (displace (ig/ref :codescene.features.components/project))
          :navigation-component (displace (ig/ref :codescene.features.components/navigation))
          :analysis-component (displace (ig/ref :codescene.features.components/analysis))
          :custom-report-component (displace (ig/ref :codescene.features.components/custom-report))}}))

(defmethod ig/init-key ::api [_ _]
  #(duct/merge-configs
     %
     {:codescene.features.api/api-component
      {:auth (displace (ig/ref :codescene.features.components/auth))
       :licensing (displace (ig/ref :codescene.features.tools.components/licensing))
       :developer-settings (displace (ig/ref :codescene.features.components/developer-settings))
       :project (displace (ig/ref :codescene.features.components/project))
       :analysis (displace (ig/ref :codescene.features.components/analysis))
       :code-coverage-storage (displace (ig/ref :codescene.features.components/code-coverage-storage))
       :analytics (displace (ig/ref :codescene.features.components/analytics))
       :delta-analysis (displace (ig/ref :codescene.features.components/delta-analysis))
       :env (displace (ig/ref :codescene.features.config/env))}}))

(defmethod ig/init-key ::plugins [_ _]
  #(duct/merge-configs
     %
     (assoc-some {:codescene.features.plugins/plugins {:encryptor (displace (ig/ref :codescene.features.crypto/encryptor))
                                                       :plugin-manager (displace (ig/ref :codescene.features.plugins/plugin-manager))}}
                 :codescene.features.plugins/plugin-manager
                 (when-not (first (vals (ig/find-derived % :codescene.features.plugins/plugin-manager)))
                   {:env (displace (ig/ref :codescene.features.config/env))}))))
