(ns codescene.features.delta.legacy-result-presenter
  "This is for presenting old delta analysis in the new delta results view.
   To accomplish that, we extract what we can from the legacy result data
   (meaning less/different info will be presented than for new results)"
  (:require [codescene.delta.legacy-delta-result :as legacy-delta-result]
            [hotspots-x-ray.recommendations.code-health.descriptions.delta-description-multi-protocol :as delta-description]
            [hotspots-x-ray.recommendations.code-health-interpretations :as chi]))

(defn- number-of-types [findings]
  (->> findings (map :name) distinct count))

(defn- number-of-files [findings]
  (->> findings (map :file) distinct count))

(defn ->finding-for-ui [get-refactorings-fn {:keys [file category description] :as _finding}]
  (let [{why-it-occurs :description how-to-fix :fix} (delta-description/describe {:title category})]
    {:name category
     :file file
     :change-type "introduced"
     :why-it-occurs why-it-occurs
     :how-to-fix how-to-fix
     :what-changed description
     :refactoring-examples (get-refactorings-fn category (chi/filename->language file))}))

(defn- negative-findings [get-refactorings-fn result]
  (let [findings (->> (legacy-delta-result/negative-findings* result)
                      (map (partial ->finding-for-ui get-refactorings-fn)))]
    {:number-of-types (number-of-types findings)
     :number-of-files-touched (number-of-files findings)
     :findings findings}))

(def no-findings {:number-of-types 0
                  :number-of-files-touched 0
                  :findings []})

(defn transform-results [get-refactorings-fn result]
  (let [negative-findings (negative-findings get-refactorings-fn result)
        negative-review? (boolean (some second (:quality-gates result)))]
    {:negative-findings negative-findings
     :suppressions no-findings
     :positive-findings no-findings
     :is-negative-review negative-review?
     :negative-impact-count (-> negative-findings :findings count)
     :positive-impact-count 0
     :affected-hotspots 0}))
