(ns codescene.features.config.sets
  (:require [codescene.features.util.maps :refer [map-of]]
            [codescene.features.config.properties :as p]))

(defn config-set [metadata data properties state]
  (map-of metadata data properties state))

(defn to-ui-params [{:keys [properties data state] :as config-set}]
  (when-not (= :live state)
    (throw (ex-info (format "Configuration set in state %s instead of %s" state :live) {})))
  (assoc config-set
    :data (p/to-params properties data)
    :state :ui-params))

(defn typed-config-set
  [all-type-options data state]
  (let [t (:webhook-provider-type data (:type data))]
    (config-set {:type t} data (all-type-options t) state)))