(ns codescene.features.components.custom-report
  (:require [clojure.spec.alpha :as s]
            [codescene.features.spec.commons :as commons-spec]))

(s/def ::project-id commons-spec/int-or-string)
(s/def ::analysis-id commons-spec/int-or-string)
(s/def ::with-header? boolean?)
(s/def ::report_type string?)
(s/def ::fields_list (s/coll-of string?))
(s/def ::custom-report (s/keys :req-un [::commons-spec/id ::commons-spec/name ::report_type ::fields_list]))

(s/def ::project-spec (s/keys :req-un [::project-id ::analysis-id ::name]
                              :opt-un [::with-header?]))

(defprotocol CustomReportComponent
  (-custom-report [this name])
  (-custom-report-data [this custom-report project-spec]))

(s/fdef custom-report
        :args (s/cat :this some?
                     :name string?)
        :ret (s/nilable ::custom-report))
(defn custom-report
  "return a custom report by name"
  [this name]
  (-custom-report this name))

(s/fdef custom-report-data
        :args (s/cat :this some?
                     :custom-report ::custom-report
                     :project-spec ::project-spec)
        :ret string?)
(defn custom-report-data
  "return a custom report data for give custom report and project spec"
  [this custom-report project-spec]
  (-custom-report-data this custom-report project-spec))