(ns codescene.features.components.code-coverage-storage
  (:require [clojure.spec.alpha :as s]
            [codescene.features.spec.commons :as commons-spec]))

(defprotocol CodeCoverageStorage
  (-request-upload [this user metadata])
  (-metadata [this upload-id])
  (-upload-data [this user upload-id data])
  (-abort-upload [this upload-id])
  (-delete-data [this user query-params])
  (-query-data [this user query-params]))

(defn request-upload
  [this user metadata]
  (-request-upload this user metadata))

(defn metadata
  [this upload-id]
  (-metadata this upload-id))

(defn upload-data
  [this user upload-id data]
  (-upload-data this user upload-id data))

(defn abort-upload
  [this upload-id]
  (-abort-upload this upload-id))

(defn delete-data
  [this user query-params]
  (-delete-data this user query-params))

(defn query-data
  [this user query-params]
  (-query-data this user query-params))