(ns codescene.features.code-coverage.parsers.core
  (:require [codescene.features.code-coverage.parsers.open-clover-parser :as open-clover-parser]
            [codescene.features.code-coverage.parsers.cobertura-parser :as cobertura-parser]
            [codescene.features.code-coverage.parsers.jacoco-parser :as jacoco-parser]
            [codescene.features.code-coverage.parsers.lcov-parser :as lcov-parser]
            [codescene.features.code-coverage.parsers.bullseye-parser :as bullseye-parser]
            [codescene.features.code-coverage.parsers.dotcover-parser :as dotcover-parser]
            [codescene.features.code-coverage.parsers.open-cover-parser :as open-cover-parser]
            [codescene.features.code-coverage.parsers.ncover-parser :as ncover-parser]
            [codescene.features.code-coverage.parsers.edn-parser :as edn-parser]))

(def parsers [(open-clover-parser/->Parser)
              (cobertura-parser/->Parser)
              (jacoco-parser/->Parser)
              (lcov-parser/->Parser)
              (bullseye-parser/->Parser)
              (dotcover-parser/->Parser)
              (open-cover-parser/->Parser)
              (ncover-parser/->Parser)
              (edn-parser/->Parser)])
