(ns codescene.features.api.spec.delta-analysis
  (:require [clojure.spec.alpha :as s]
            [spec-tools.spec :as spec])
  (:import (org.joda.time DateTime)))

(s/def ::page spec/int?)
(s/def ::max_pages spec/int?)
(s/def ::id spec/int?)
(s/def ::project_id spec/int?)
(s/def ::repository spec/string?)
(s/def ::ref spec/string?)
(s/def ::analysistime #(instance? DateTime %))
(s/def ::recommended_review_level spec/string?)
(s/def ::degrades_in_code_health spec/boolean?)
(s/def ::violates_goal spec/boolean?)
(s/def ::quality_gates (s/keys :opt-un [::degrades_in_code_health ::violates_goal]))
(s/def ::commits (s/coll-of spec/string?))
(s/def ::delta_analyses (s/coll-of (s/keys :req-un [::id ::ref ::analysistime ::repository ::project_id])))
(s/def ::delta_analyses_list (s/keys :req-un [::page ::max_pages ::delta_analyses]))
(s/def ::delta_analysis (s/keys :req-un [::id ::project_id ::repository ::analysistime] :opt-un [::recommended_review_level ::quality_gates ::commits]))

