(ns codescene.features.api.delta-analyses
  (:require [codescene.features.util.api :as api-utils]
            [codescene.features.api.core :as api-core]
            [codescene.features.components.delta-analysis :as delta-analysis]))

(defn- with-ref
  [api-prefix project-id delta-analysis]
  (assoc delta-analysis :ref (format "%s%s/delta-analyses/%s" (api-utils/project-url-prefix api-prefix) project-id (:id delta-analysis))))

(defn list-result
  [system project-id page]
  (let [api-prefix (api-core/api-root system)
        delta-analysis (api-core/api-delta-analyses system)
        all-delta-analyses-in-project (->> (delta-analysis/all-in-project delta-analysis project-id)
                                           (map #(dissoc % :analysisid :description :resultpath)))]
    ;; we need to return a vector to avoid issue from compojure-api which return reverses LazySeqs
    ;;(see https://github.com/metosin/compojure-api/issues/412)
    (api-utils/paginated-list-result (into [] all-delta-analyses-in-project)
                                     {:page page
                                      :list-kw :delta-analyses
                                      :processing-fn (partial with-ref api-prefix project-id)})))

(defn delta-analysis-result
  [system project-id delta-analysis-id]
  (if-let [delta-analysis-by-id (-> (api-core/api-delta-analyses system)
                                    (delta-analysis/by-id project-id delta-analysis-id))]
    (api-utils/ok delta-analysis-by-id)
    (api-utils/not-found (format "There's no delta analysis matching the ID %s for project with ID %s" delta-analysis-id project-id))))
