(ns codescene.features.analytics.events
  (:require
   [clojure.string :as str]))

(defn- amplitude-friendly-trace
  "Make sure the trace is accepted by amplitude,
   meaning make it vector of strings with a limit on the number of elements"
  [max-trace-size trace]
  (let [count (count trace)
        half-trace (int (/ max-trace-size 2))]
    (->> (if (> count max-trace-size)
           (concat (take half-trace trace) ["..."] (drop (- count half-trace) trace))
           trace)
         (mapv str))))

(defn exception->error
  ([exception]
   (exception->error exception 200))
  ([exception max-trace-size]
   (update (Throwable->map exception) :trace (partial amplitude-friendly-trace max-trace-size))))




