(ns clj-codescene-plugin.virtual-code-reviewer
  (:require [clj-codescene-plugin.setting :as setting])
  (:import [com.codescene.plugin.virtualcodereviewer Recommendation Remedy RecommendationType Context]))

(defn- ->Remedy [{:keys [description link]}]
  (reify Remedy
    (getDescription [this] description)
    (getLink [this] link)))

(defn- ->Recommendation [type {:keys [title where why how-to-fix]}]
  (reify Recommendation
    (getWhere [this] where)
    (getTitle [this] title)
    (getWhy [this] why)
    (getHowToFix [this] (map ->Remedy how-to-fix))
    (getType [this] type)))

(def ->GoodRecommendation (partial ->Recommendation RecommendationType/GOOD))
(def ->WarningRecommendation (partial ->Recommendation RecommendationType/WARNING))
(def ->ProblemRecommendation (partial ->Recommendation RecommendationType/PROBLEM))

(defn- RecommendationType->indication [type]
  (case (.name type)
    "GOOD" :good
    "WARNING" :warning
    "PROBLEM" :problem))

(defn- Remedy->map [r]
  {:description (.getDescription r)
   :link (.getLink r)})

(defn Recommendation->map [r]
  {:where (.getWhere r)
   :title (.getTitle r)
   :why (.getWhy r)
   :how-to-fix (->> (.getHowToFix r) (map Remedy->map))
   :indication (-> (.getType r) RecommendationType->indication)})

(defn ->Context
  [{:keys [settings]}]
  (reify Context
    (getSettings [this] (if settings (map setting/->SettingValue settings) []))))
