(ns clj-codescene-plugin.system-map
  (:require [clj-codescene-plugin.setting :as setting])
  (:import (com.codescene.plugin.systemmap Context File Repository)))

(defn ->Context
  [{:keys [repositories settings]}]
  (reify Context
    (getRepositories [this] (or repositories []))
    (getSettings [this] (if settings (map setting/->SettingValue settings) []))))

(defn ->File
  [{:keys [path]}]
  (reify File
    (getPath [this] path)))

(defn ->Repository
  [{:keys [name path origin-url]}]
  (reify Repository
    (getName [this] name)
    (getPath [this] path)
    (getOriginURL [this] origin-url)))

(defn File->map [f]
  {:path (.getPath f)})

(defn Repository->map [r]
  {:name (.getName r)
   :path (.getPath r)
   :origin-url (.getOriginURL r)})

