// @flow
import $ from 'jquery';

function onProviderType() {
  var type = $('input[name="webhook-provider-type"]:checked').val();
  var githubAppPrivateKey = $('#github-app-private-key').val();
  $('.github-app-provider-toggleable').toggle(type == 'github-app');
  $('#github-app-private-key-file').prop('required', type == 'github-app' && !githubAppPrivateKey);
  $('.bitbucket-provider-toggleable').toggle(type == 'bitbucket');
  $('.bitbucket-server-provider-toggleable').toggle(type == 'bitbucket-server');
  $('.gitlab-provider-toggleable').toggle(type == 'gitlab');
  $('.azure-provider-toggleable').toggle(type == 'azure');
  $('.gerrit-provider-toggleable').toggle(type == 'gerrit');
  $('.plugin-gerrit-provider-toggleable').toggle(type == 'plugin-gerrit');
}

function setupWebhookProviderTypeHook() {
  $('input[name="webhook-provider-type"]').click(function(){
    onProviderType();
  });
}

export function init() {
  setupWebhookProviderTypeHook();
  onProviderType();
}


