// @flow
import $ from 'jquery';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as alerts from 'codescene-ui/src/alerts';
import * as complexityTrends from 'codescene-ui/src/analyses/complexity-trends';

import {parseRow} from './complexity-trend-view';

type ViewOptions = {
  complexityTrendUrl : string
};

export function init(options : ViewOptions) {
  const content = $('.complexity-trend-view .content');

  alerts.progress(content, 'The complexity trend may take several minutes to generate, please wait...');

  xhr.csv(options.complexityTrendUrl, parseRow)
    .then(data => {
      const container = $('<div>');
      if (!data || data.length === 0) {
        alerts.warning(container, 'No complexity trend data available.');
      } else {
        complexityTrends.drawComplexityTrend(container, data);
        content.html(container);
      }
    })
    .catch(err => {
      console.error(err.stack);
      alerts.warning(content, 'No complexity trend data available. CodeScene only calculates complexity trends for the top Hotspots with enough historic data.');
    });
}
