// @flow

import * as analysisDashboard from 'codescene-ui/src/analyses/dashboard-new/analysis-dashboard.jsx';
import * as fourFactorDashboard from 'codescene-ui/src/analyses/four-factor/analysis-dashboards/dashboard-container';
import * as fourFactorDashboardLazy from 'codescene-ui/src/analyses/four-factor/analysis-dashboards/dashboard-container-lazy';

import * as analysisMenu from 'codescene-ui/src/shared/dashboard-side-menu/dashboard-side-menu';
import * as authorStatistics from 'codescene-ui/src/analyses/author-statistics';
import * as deltaAnalysisResults from 'codescene-ui/src/delta-analysis/detailed-view';
import * as devopsMetrics from 'codescene-ui/src/analyses/devops/devops-metrics.jsx';
import * as developmentTimeTable from 'codescene-ui/src/analyses/devops/development-time-table.jsx';
import * as prStats from 'codescene-ui/src/analyses/pr-stats';
import * as customCodeHealthRules from 'codescene-ui/src/analyses/scope/custom-code-health-rules.js';
import * as virtualCodeReview from 'codescene-ui/src/analyses/virtual-code-review/index';
import * as xray from 'codescene-ui/src/analyses/x-ray-table-view/x-ray-table-view';
import * as xrayFunctionComplexityTrend from './xray-function-complexity-trend-view';
import * as absoluteChurnTrend from './absolute-churn-trend-view';
import * as analysisSummary from './analysis-summary-view';
import * as augmentedAnalysisView from './augmented-analysis-view';
import * as authorFragmentation from './author-fragmentation';
import * as authors from './authors-view';
import * as biomarkerView from 'codescene-ui/src/analyses/biomarkers';
import * as branchView from './branch-view';
import * as brooksLaw from './brooks-law-view';
import * as changeFrequencyDistribution from './change-frequency-distribution-view';
import * as changeFrequencyCodeHealth from 'codescene-ui/src/analyses/change-frequency-code-health';
import * as churnByTask from './churn-by-task-view';
import * as codeAge from './code-age-view';
import * as commits from './commits-view';
import * as complexityTrend from './complexity-trend-view';
import * as complexityTrendWarnings from './complexity-trend-warnings-view';
import * as costsTrend from './costs-trend-view';
import * as fileContent from './file-content-view';
import * as issues from 'codescene-ui/src/analyses/scope/issues-view';
import * as highRiskCommitsWarning from './high-risk-commits-warning-view';
import * as knowledgeDistribution from './knowledge-distribution-view';
import * as knowledgeLoss from './knowledge-loss-view';
import * as modusOperandiTrends from './modus-operandi-view';
import * as offboardingSimulationView from './offboarding-simulation-view';
import * as parallelDevelopment from './parallel-development-view';
import * as authorsWarning from './authors-warning-view';
import * as riskByCommit from './project-management-risk-by-commit-view';
import * as riskTrend from './project-management-risk-view';
import * as risingHotspots from './rising-hotspots-view';
import * as socialNetworks from './social-networks-view';
import * as teamCodeAlignmentExplorer from 'codescene-ui/src/analyses/team-code-alignment-explorer';
import * as teamDynamicsIndividualsSystemMap from 'codescene-ui/src/analyses/team-dynamics-individuals-system-map';
import * as teamDynamicsTeamsSystemMap from 'codescene-ui/src/analyses/team-dynamics-teams-system-map';

import * as conwaysLawSystemMap from 'codescene-ui/src/analyses/conways-law-system-map';
import * as stackedComplexity from './stacked-complexity-view';
import * as sumOfCouplings from './temporal-coupling-sum-of-couplings-view';
import * as systemComplexity from './system-complexity-view';
import * as systemHealthView from './system-health-view';
import * as codeHotspotsSystemMap from 'codescene-ui/src/analyses/code-hotspots-system-map';
import * as codeHotspotsTdFrictionSystemMap from 'codescene-ui/src/analyses/code-hotspots-td-friction-system-map';
import * as architectureHotspotsSystemMap from 'codescene-ui/src/analyses/architecture-hotspots-system-map';
import * as teamContribution from './team-contribution-view';
import * as temporalCouplingBase from './temporal-coupling-base-view';
import * as projectHeader from 'codescene-ui/src/analyses/project-header/project-header.tsx';
import * as codeCoverage from 'codescene-ui/src/analyses/code-coverage';

export {
  analysisDashboard,
  fourFactorDashboard,
  fourFactorDashboardLazy,
  analysisMenu,
  authorStatistics,
  customCodeHealthRules,
  deltaAnalysisResults,
  devopsMetrics,
  developmentTimeTable,
  prStats,
  virtualCodeReview,
  xray,
  xrayFunctionComplexityTrend,
  absoluteChurnTrend,
  analysisSummary,
  // v2
  conwaysLawSystemMap,
  augmentedAnalysisView,
  authorFragmentation,
  authors,
  biomarkerView,
  branchView,
  brooksLaw,
  changeFrequencyDistribution,
  changeFrequencyCodeHealth,
  churnByTask,
  codeAge,
  commits,
  complexityTrend,
  complexityTrendWarnings,
  costsTrend,
  fileContent,
  issues,
  highRiskCommitsWarning,
  knowledgeDistribution,
  knowledgeLoss,
  modusOperandiTrends,
  offboardingSimulationView,
  parallelDevelopment,
  projectHeader,
  authorsWarning,
  riskByCommit,
  riskTrend,
  risingHotspots,
  socialNetworks,
  teamCodeAlignmentExplorer,
  teamDynamicsIndividualsSystemMap,
  teamDynamicsTeamsSystemMap,
  stackedComplexity,
  sumOfCouplings,
  systemComplexity,
  systemHealthView,
  codeHotspotsSystemMap,
  codeHotspotsTdFrictionSystemMap,
  architectureHotspotsSystemMap,
  teamContribution,
  temporalCouplingBase,
  codeCoverage,
};
