// @flow
import d3 from 'd3';
import $ from 'jquery';

import * as xhr from 'codescene-ui/src/browser/xhr';

type ViewOptions = {
  trendWarningsUrl : string,
  projectId : number,
  analysisId : number
};

export function init(options : ViewOptions) {
  const container = $('.analysis-trend-warnings');

  function appendWarnings(warningSpots) {
    d3.select(container.get(0))
      .append('tbody')
      .selectAll('tr')
      .data(warningSpots)
      .enter()
      .append('tr')
      .attr('class', d => `hotspot-${d.warning.toLowerCase()}`)
      .html(function (d) {
        const trendUrl = window.baseUrl + options.projectId + '/analyses/' + options.analysisId +
              '/code/hotspots/complexity-trend?name=' + encodeURIComponent(d.module);
        return `
          <td class="warning-color"></td>
          <td class="column-module"><a href="${trendUrl}"><span class="filename">${d.module}</span></a></td>
          <td class="column-lines-of-code">${d.code}</td>
        `;
      });
  }

  function sortBySize(warningSpots) {
    return warningSpots.sort(function(a,b) { return +a.code < +b.code; });
  }

  xhr.csv(options.trendWarningsUrl)
    .then(data => {
      var warningSpots = data.filter(function(d) { return d.warning !== 'None'; });
      var redSpots = sortBySize(warningSpots.filter(function(d) { return d.warning === 'Red'; }));
      var yellowSpots = sortBySize(warningSpots.filter(function(d) { return d.warning === 'Yellow'; }));

      appendWarnings(redSpots.concat(yellowSpots));
    });
}
