// @flow
import $ from 'jquery';

import * as xhr from 'codescene-ui/src/browser/xhr';
import * as alerts from 'codescene-ui/src/alerts';
import * as ageDistribution from 'codescene-ui/src/analyses/age-distribution';

type CodeAgeViewOptions = {
  codeAgeMapUrl : string,
  codeAgeTrendUrl : string,
  sizeLabelCutOffPoint: number
};

function parseAgeTrendRow(d) {
  d.frequency = +d.frequency;
  return d;
}

export function initDistribution(options : CodeAgeViewOptions) {
  const ageDistributionContainer = $('#agedistribution');

  xhr.csv(options.codeAgeTrendUrl, parseAgeTrendRow)
    .then(data => {
      var width = ageDistributionContainer.width();
      ageDistribution.draw(
        ageDistributionContainer,
        width, width / 2,
        {
          top: 20,
          right: 60,
          bottom: 100,
          left: 100
        },
        data);
    })
    .catch(err => {
      console.error(err);
      alerts.error(ageDistributionContainer, 'Failed to get age distribution data.');
    });
}
