-- name: insert-project-group<!
insert into project_groups (name, parent_id) values (:name, :parent_id)

-- name: update-project-group-by-id!
update project_groups
set name = :name
where id = :id

-- name: select-project-groups
select id, name, parent_id, count(pga.project_id) project_count
from project_groups pg left join project_groups_assignments pga
on pg.id = pga.group_id
group by pg.id

-- name: select-project-group-by-id
select id, name, parent_id, pga.project_id project_id from project_groups pg
left join project_groups_assignments pga on pg.id = pga.group_id
where pg.id = :id

-- name: delete-project-group-by-id!
delete from project_groups
where id = :id

-- name: add-project-to-group!
insert into project_groups_assignments (project_id, group_id)
values (:project_id, :group_id)

-- name: move-project-to-group!
update project_groups_assignments
set group_id = :group_id
where project_id = :project_id

-- name: remove-project-from-group!
delete from project_groups_assignments
where project_id = :project_id

-- name: find-project-group-assignment
select pg.id, pg.name, pg.parent_id from project_groups_assignments pga
join project_groups pg on pg.id = pga.group_id
where pga.project_id = :project_id
