-- name: select-extensions
select *
from configuration_extensions

-- name: select-extensions-by-external-id
select *
from configuration_extensions
where external_id = :external_id

-- name: delete-extensions!
delete from configuration_extensions

-- name: delete-extensions-by-external-id!
delete from configuration_extensions 
where external_id = :external_id

-- name: insert-extension<!
insert into configuration_extensions
    (external_id, name)
values (:external_id, :name)

-- name: update-extension-by-external-id!
update configuration_extensions
set name =:name
where external_id = :external_id

-- name: select-settings-by-extension-id
select *
from extension_settings
where extension_id = :extension_id

-- name: select-settings-by-extension-and-external-id
select *
from extension_settings
where extension_id = :extension_id
and external_id = :external_id

-- name: delete-settings!
delete from extension_settings 

-- name: delete-settings-by-extension-id!
delete from extension_settings 
where extension_id = :extension_id

-- name: delete-project-settings-by-extension-id!
delete from extension_settings 
where extension_id = :extension_id

-- name: insert-setting<!
insert into extension_settings
    (external_id, name, type, extension_id)
values (:external_id, :name, :type, :extension_id)

-- name: update-settings-by-extension-and-external-id!
update extension_settings
set name =:name, type = :type
where extension_id = :extension_id
and external_id = :external_id

-- name: select-values
select id, val as `value`, setting_id, project_id, group_id
from extension_settings_values

-- name: select-global-values-by-setting-id
select id, val as `value`, setting_id, project_id, group_id
from extension_settings_values
where setting_id = :setting_id
and group_id is null
and project_id is null

-- name: select-values-by-setting-and-group-id
select id, val as `value`, setting_id, project_id, group_id
from extension_settings_values
where setting_id = :setting_id
and group_id = :group_id

-- name: select-values-by-setting-and-project-id
select id, val as `value`, setting_id, project_id, group_id
from extension_settings_values
where setting_id = :setting_id
and project_id = :project_id

-- name: select-global-values-by-extension-id
select es.external_id, esv.val as `value`, es.type
from extension_settings_values as esv
join extension_settings as es on es.id = esv.setting_id
where es.extension_id = :extension_id
and group_id is null
and project_id is null

-- name: select-values-by-extension-and-group-id
select es.external_id, esv.val as `value`, es.type
from extension_settings_values as esv
join extension_settings as es on es.id = esv.setting_id
where es.extension_id = :extension_id
and group_id = :group_id

-- name: select-values-by-extension-and-project-id
select es.external_id, esv.val as `value`, es.type
from extension_settings_values as esv
join extension_settings as es on es.id = esv.setting_id
where es.extension_id = :extension_id
and project_id = :project_id

-- name: delete-values!
delete from extension_settings_values 

-- name: delete-values-by-setting-and-group-id!
delete from extension_settings_values 
where setting_id = :setting_id
and group_id = :group_id

-- name: delete-values-by-setting-and-project-id!
delete from extension_settings_values 
where setting_id = :setting_id
and project_id = :project_id

-- name: delete-global-values-by-setting-id!
delete from extension_settings_values 
where setting_id = :setting_id
and group_id is null
and project_id is null

-- name: insert-value<!
insert into extension_settings_values
    (val, setting_id, project_id, group_id)
values (:value, :setting_id, :project_id, :group_id)
