
-- name: insert-pending-operation!
insert into pending_operations (id, status) values (:id, :status);

-- name: insert-val-parameter!
insert into pending_operations_params
       (operation_id, param_name, val)
       values(:operation_id, :param_name, :val);

-- name: update-val-parameter!
update pending_operations_params
set val =:val where operation_id = :operation_id and param_name = :param_name;

-- name: get-pending-operation-by-id
select * from pending_operations where id = :id;

-- name: set-pending-operation-status!
update pending_operations
set status =:status, message = :message where id = :id;

-- name: delete-pending-operation!
delete from pending_operations where id = :id;

-- name: get-session-parameters
select * from pending_operations_params where operation_id = :operation_id;

-- name: delete-old-completed-operations!
delete from pending_operations
       where (status = 'complete' or status = 'error')
       and
       started < timestampadd(HOUR, -48, current_timestamp());

-- name: delete-all-very-old-operations!
delete from pending_operations
       where started < timestampadd(HOUR, -72, current_timestamp());

-- name: delete-all-session-parameters!
delete from pending_operations_params
       where operation_id = :operation_id;
