-- name: query-proxy-server-configuration
-- Returns the proxy server configuration, if any.
--
-- Network configuration is stored in a single (default) row in network_config table.
-- For now, there are only single global settings - the default row is inserted
-- by migration script (see 0043-add-network-config.up.sql)
SELECT proxy_host, proxy_port, proxy_user, proxy_password FROM network_config;

-- name: insert-proxy-server-configuration!
-- Updates the global proxy server configuration.
UPDATE network_config
  SET proxy_host = :proxy_host, proxy_port = :proxy_port, proxy_user = :proxy_user, proxy_password = :proxy_password;

-- name: delete-proxy-server-configuration!
-- Clears the existing (if any) proxy settings.
UPDATE network_config
  SET proxy_host = NULL, proxy_port = NULL, proxy_user = NULL, proxy_password = NULL;

-- name: global-offline-mode-active?
-- Returns true if global offline mode is active, false otherwise.
SELECT offline_mode from network_config;

-- name: update-global-offline-mode!
-- Returns true if global offline mode is active, false otherwise.
UPDATE network_config SET offline_mode = :enabled?;

-- name: select-codescene-host-url
SELECT codescene_host_url from network_config;

-- name: update-codescene-host-url!
UPDATE network_config SET codescene_host_url = :codescene_host_url;
