-- name: get-code-improvements-by-project
select *
from code_improvements
where project_id = :project_id
order by model_score desc, delta_file_score desc;

-- name: get-code-improvements-by-project-and-type
select *
from code_improvements
where project_id = :project_id
and improvement_type = :improvement_type
and language = :language
order by model_score desc, delta_file_score desc;

-- name: delete-code-improvements!
delete
from code_improvements
where project_id = :project_id;

-- name: insert-code-improvement!
insert into code_improvements
(id, project_id, previous_rev, current_rev, filename, improvement_type, diff, model_score,
    author_name, author_email, language, commit_title, commit_full_message, delta_file_score, commit_date, training_data) -- sql column names
values
(:id, :project_id, :previous_rev, :current_rev, :entity, :improvement_type, :diff, :model_score,
    :author, :author_email, :language, :commit_title, :commit_full_message, :delta_file_score, :basic_date_time, :training_data); -- clojure key names
